/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.serializers;

import dev.gigaherz.jsonthings.things.IFlexItem;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.serializers.ItemVariantProvider;
import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public interface IItemFactory<T extends Item>
extends ItemVariantProvider {
    public T construct(Item.Properties var1, ItemBuilder var2);

    @Override
    default public void provideVariants(ResourceKey<CreativeModeTab> tabKey, CreativeModeTab.Output output, CreativeModeTab.ItemDisplayParameters parameters, @Nullable ItemBuilder context, boolean explicit) {
        Item item = ((IFlexItem)Objects.requireNonNull(context).get()).self();
        if (item instanceof ItemVariantProvider) {
            ItemVariantProvider provider = (ItemVariantProvider)item;
            provider.provideVariants(tabKey, output, parameters, context, explicit);
        } else {
            output.m_246342_(item.m_7968_());
        }
    }

    public static class WithVariants<T extends Item>
    implements IItemFactory<T> {
        private final IItemFactory<T> innerFactory;
        private final ItemVariantProvider stackProvider;

        public WithVariants(IItemFactory<T> innerFactory, ItemVariantProvider stackProvider) {
            this.innerFactory = innerFactory;
            this.stackProvider = stackProvider;
        }

        @Override
        public T construct(Item.Properties properties, ItemBuilder builder) {
            return this.innerFactory.construct(properties, builder);
        }

        @Override
        public void provideVariants(ResourceKey<CreativeModeTab> tabKey, CreativeModeTab.Output output, CreativeModeTab.ItemDisplayParameters parameters, @Nullable ItemBuilder context, boolean explicit) {
            this.stackProvider.provideVariants(tabKey, output, parameters, context, explicit);
        }
    }
}

